<?php
header('Content-Type: application/json; charset=utf-8');
header("Access-Control-Allow-Origin: *");
header("Access-Control-Allow-Methods: POST");

include "conexion.php";

// Recibir código o DNI
$codigo = $_POST['codigo'] ?? '';

if (empty($codigo)) {
    echo json_encode([
        "status" => "error",
        "message" => "Código o DNI no proporcionado"
    ]);
    exit;
}

// Consulta segura
$stmt = $conn->prepare(
    "SELECT id, dni, nombres, apellidos, celular, tipo_documento, descripcion,
            pdf_url, fecha, estado, area_destino
     FROM tramites
     WHERE dni = ? OR id = ?
     LIMIT 1"
);

if (!$stmt) {
    echo json_encode([
        "status" => "error",
        "message" => $conn->error
    ]);
    exit;
}

$stmt->bind_param("ss", $codigo, $codigo);
$stmt->execute();

$result = $stmt->get_result();

if ($row = $result->fetch_assoc()) {

    echo json_encode([
        "status" => "success",
        "data" => $row
    ]);

} else {

    echo json_encode([
        "status" => "error",
        "message" => "Trámite no encontrado"
    ]);
}

$stmt->close();
$conn->close();
?>
