<?php
require __DIR__ . "/conexion.php";   // ← ahora sí carga $cn
require __DIR__ . "/fpdf/fpdf.php";

$pdf = new FPDF();
$pdf->AddPage();

// ENCABEZADO
$pdf->SetFont("Arial", "B", 16);
$pdf->Cell(0, 10, "REPORTE GENERAL DE TRAMITES", 0, 1, "C");

$pdf->Ln(3);

$pdf->SetFont("Arial", "", 10);
$pdf->Cell(0, 6, "Fecha: " . date("d/m/Y H:i"), 0, 1);

// TITULOS
$pdf->SetFont("Arial", "B", 10);
$pdf->Cell(25, 8, "DNI", 1);
$pdf->Cell(50, 8, "Nombre", 1);
$pdf->Cell(45, 8, "Area", 1);
$pdf->Cell(30, 8, "Estado", 1);
$pdf->Cell(40, 8, "Fecha", 1);
$pdf->Ln();

// CONSULTA A BD
$sql = $conn->query("SELECT * FROM tramites ORDER BY fecha DESC");

$pdf->SetFont("Arial", "", 9);

// FILAS
while ($r = $sql->fetch_assoc()) {
    $pdf->Cell(25, 8, $r['dni'], 1);
    $pdf->Cell(50, 8, $r['nombres'] . ' ' . $r['apellidos'], 1);
    $pdf->Cell(45, 8, $r['area_destino'], 1);
    $pdf->Cell(30, 8, $r['estado'], 1);
    $pdf->Cell(40, 8, $r['fecha'], 1);
    $pdf->Ln();
}

$pdf->Output();
