<?php
header('Content-Type: application/json; charset=utf-8');

include "conexion.php";

// Leer POST
$dni = $_POST['dni'] ?? '';
$nombres = $_POST['nombres'] ?? '';
$apellidos = $_POST['apellidos'] ?? '';
$celular = $_POST['celular'] ?? '';
$tipo_documento = $_POST['tipo_documento'] ?? '';
$descripcion = $_POST['descripcion'] ?? '';
$area_destino = $_POST['area_destino'] ?? '';
$pdf_url = $_POST['pdf_url'] ?? '';

if (empty($dni) || empty($nombres)) {
    echo json_encode([
        "status" => "error",
        "message" => "Campos obligatorios faltantes"
    ]);
    exit;
}

$stmt = $conn->prepare(
    "INSERT INTO tramites 
    (dni, nombres, apellidos, celular, tipo_documento, descripcion, pdf_url, fecha, estado, area_destino)
    VALUES (?, ?, ?, ?, ?, ?, ?, NOW(), 'Registrado', ?)"
);

if (!$stmt) {
    echo json_encode([
        "status" => "error",
        "message" => $conn->error
    ]);
    exit;
}

$stmt->bind_param(
    "ssssssss",
    $dni,
    $nombres,
    $apellidos,
    $celular,
    $tipo_documento,
    $descripcion,
    $pdf_url,
    $area_destino
);

if ($stmt->execute()) {
    echo json_encode([
        "status" => "success",
        "message" => "Trámite registrado"
    ]);
} else {
    echo json_encode([
        "status" => "error",
        "message" => $stmt->error
    ]);
}

$stmt->close();
$conn->close();
?>
